/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.vw.base.VWDebug;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import simulator.publisher.VWSIMPublishedSimulation;

public class VWSIMPublishedSimDataNode
extends VWSIMBaseNode {
    private static final ImageIcon publishedSimIcon16 = VWSIMImageLoader.createImageIcon("simulation_16.gif");
    private VWSIMBaseNode m_parentFolder = null;
    private VWSIMPublishedSimulation m_publishedSimData = null;
    private String m_userName = null;
    private String m_simulationName = null;
    private GregorianCalendar m_launchGcl = null;

    public VWSIMPublishedSimDataNode(VWSIMPublishedSimulation publishedSimulation, VWSIMBaseNode parentFolder) {
        super(publishedSimulation.getSimulationName(), 36);
        try {
            this.setIcon16(publishedSimIcon16);
            this.m_parentFolder = parentFolder;
            this.m_publishedSimData = publishedSimulation;
            this.m_simulationName = this.m_publishedSimData.getSimulationName();
            this.m_userName = this.m_publishedSimData.getUserName();
            this.m_launchGcl = this.m_publishedSimData.getDateTime();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public TreeNode getParent() {
        return this.m_parentFolder;
    }

    public TreeNode getRoot() {
        if (this.m_parentFolder != null) {
            return this.m_parentFolder.getRoot();
        }
        return null;
    }

    public VWSIMPublishedSimulation getPublishedSimulation() {
        return this.m_publishedSimData;
    }

    public void setPublishedSimData(VWSIMPublishedSimulation publishedSimData) {
        this.m_publishedSimData = publishedSimData;
    }

    public String getSimulationName() {
        return this.m_simulationName;
    }

    public String getSimulationLauncherName() {
        return this.m_userName;
    }

    public Date getSimulationLauncherDate() {
        Date dt = this.m_launchGcl.getTime();
        return dt;
    }

    public void refresh() {
    }
}

